import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd  
import pickle
from decision_company import read_csv_file, is_null, sum_up
  
# Load the dataset using the custom function  
credit_customers = read_csv_file(os.path.join(sys.argv[1], 'credit_customers.csv'))  
  
# Check for missing values using the custom functions  
missing_values = is_null(credit_customers)  

print("Missing values per column:\n", sum_up(missing_values))  
# pickle.dump(sum_up(missing_values),open("./ref_result/missing_values.pkl","wb"))


import pandas as pd  
import pickle
from decision_company import read_csv_file, select_data_types, get_columns, get_dummies

# Load the dataset  
  
# Identify categorical variables  
categorical_columns = get_columns(select_data_types(credit_customers,['object']))  
  
# Initialize an empty list to store nominal categorical columns  
nominal_categorical_columns = list(categorical_columns)  
  
# Suggest encoding methods  
print("Suggested encoding methods:")  
print("1. One-hot encoding for nominal categorical variables:")  
for col in nominal_categorical_columns:  
    print("   -", col)  
  
# Example code for one-hot encoding  
credit_customers_encoded = get_dummies(credit_customers, columns=nominal_categorical_columns)  
print("\nData after one-hot encoding:\n", credit_customers_encoded.head())  
  
# Save the encoded data to a file  
# pickle.dump(credit_customers_encoded, open("./ref_result/credit_customers_encoded.pkl", "wb"))  


import pandas as pd  
import numpy as np
from sklearn.preprocessing import StandardScaler 
import pickle
from decision_company import read_csv_file, select_data_types, get_columns, df_copy, get_min_value, get_max, get_first_n_rows, fetch_column, create_standard_scaler, fit_transform_standard_scaler, col_assign_val
  
  
# Load the dataset  
  
# Identify numerical variables  
numerical_columns = get_columns(select_data_types(credit_customers, ['number']))  
  
# Calculate the range of each numerical column  
ranges = {}  
for col in numerical_columns:  
    col_data = fetch_column(credit_customers, col)  
    ranges[col] = get_max(col_data) - get_min_value(col_data)  
  
# Check if normalization is necessary  
normalization_needed = False  
for col, range_ in ranges.items():  
    if range_ > 1:  
        normalization_needed = True  
        break  
  
# It's true:  
# Normalize the data using Standard Scaling  
if normalization_needed: 
    scaler = create_standard_scaler()  
    credit_customers_normalized = df_copy(credit_customers)  
    col_assign_val(credit_customers_normalized, numerical_columns, fit_transform_standard_scaler(scaler, credit_customers[numerical_columns]))
  
    print("Data after Standard Scaling:\n", get_first_n_rows(credit_customers_normalized))  
    # pickle.dump(get_first_n_rows(credit_customers_normalized), open("./ref_result/credit_customers_normalized_head.pkl", "wb"))  
else:
    print("Normalization is not needed.")  


import pandas as pd  
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
from sklearn.metrics import silhouette_score  
import matplotlib.pyplot as plt  
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, get_silhouette_score, show_plots, create_figure, set_plot_title, set_yaxis_label, set_plot_xlabel, save_plot, plot, grid, col_assign_val
  
# Load the dataset  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Apply Label Encoding to 'savings_status' and 'employment'  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  

col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))  
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))
  
# Apply One-Hot Encoding to 'credit_history'  
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data using Standard Scaling  
scaler = create_standard_scaler()
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering)  
  
# Determine the sum of squared distances for different number of clusters  
# Calculate silhouette scores for different number of clusters  
silhouette_scores = []  
  
for cluster_num in range(2, 15):  # Starting from 2 because silhouette score is not defined for 1 cluster  
    kmeans = create_kmeans(n_clusters=cluster_num, random_state=42)  
    cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
    silhouette_avg = get_silhouette_score(data_for_clustering_scaled, cluster_labels)  
    silhouette_scores.append(silhouette_avg)  
  
# Plot silhouette scores  
create_figure(figsize=(10, 6))  
plot(range(2, 15), silhouette_scores, marker='o', linestyle='--')  
set_plot_title('Silhouette Scores for Different Number of Clusters')  
set_plot_xlabel('Number of Clusters')  
set_yaxis_label('Silhouette Score')  
grid(True)  
save_plot('ref_result/Silhouette_Scores.png')  
# show_plots()  

import pandas as pd  
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
import pickle
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, col_assign_val, fetch_column
  
# Load the dataset  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Preprocess the data  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data  
scaler = create_standard_scaler()  
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering)  
  
# Perform K-means clustering  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
  
# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)
  
# Return the clustering algorithm used, parameters chosen, and resulting customer segments  
result = ("K-means", {"n_clusters": 4, "random_state": 42}, fetch_column(credit_customers, ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status', 'cluster']))
print("result:\n", result)

import pandas as pd  
import numpy as np  
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
import pickle  
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, fetch_column, check_elements_in_list, extract_unique_values, convert_np_to_list, col_assign_val
  
# Load the dataset  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Preprocess the data  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data  
scaler = create_standard_scaler()  
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering)  
  
# Perform K-means clustering  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
  
# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)  
  
# Filter the dataset based on the specified criteria  
good_credit_history = check_elements_in_list(fetch_column(credit_customers, 'credit_history'), ['existing paid', 'all paid'])  
age_group = (fetch_column(credit_customers, 'age') >= 25) & (fetch_column(credit_customers, 'age') <= 45)  
stable_employment = check_elements_in_list(fetch_column(credit_customers, 'employment'), ['>=7', '4<=X<7'])  
  
# Combine the filters and apply them to the dataset  
target_customers = credit_customers[good_credit_history & age_group & stable_employment] 
  
# Extract the target customer segments  
target_customer_segments = convert_np_to_list(extract_unique_values(fetch_column(target_customers, 'cluster')))  
  
# Return the list of target customer segments  
print("target_customer_segments:\n", target_customer_segments)  
# pickle.dump(target_customer_segments, open("./ref_result/target_customer_segments.pkl", "wb"))  


import pandas as pd  
import numpy as np
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
import pickle
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, fetch_column, check_elements_in_list, extract_unique_values, convert_np_to_list, col_assign_val, series_get_quantile

  
# Load the dataset  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Preprocess the data by applying Label Encoding to 'savings_status' and 'employment'  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(create_label_encoder(), data_for_clustering['savings_status']) ) 
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(create_label_encoder(), data_for_clustering['employment'])) 
  
# Apply One-Hot Encoding to 'credit_history'  
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data using Standard Scaling  
data_for_clustering_scaled = fit_transform_standard_scaler(create_standard_scaler(), data_for_clustering)  
  
# Perform K-means clustering with 4 clusters  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
  
# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)  
  
# Identify additional customer segments with potential for responsiveness to promotions and financing options  
# Criteria: customers with a good credit history and a high credit amount  
good_credit_history = check_elements_in_list(fetch_column(credit_customers, 'credit_history'), ['no credits/all paid'])  
high_credit_amount = fetch_column(credit_customers, 'credit_amount') > series_get_quantile(fetch_column(credit_customers, 'credit_amount'), q=0.75)  
  
# Combine the filters and apply them to the dataset  
potential_customers = credit_customers[good_credit_history & high_credit_amount]  
  
# Extract the additional customer segments  
additional_customer_segments = convert_np_to_list(extract_unique_values(fetch_column(potential_customers, 'cluster')))  
  
# Exclude the target customer segments identified in the previous step  
target_customer_segments = [1, 2]  # Replace this list with the target customer segments from the previous step  
additional_customer_segments = [segment for segment in additional_customer_segments if segment not in target_customer_segments]  
  
# Return the list of additional customer segments  
print("additional_customer_segments:\n", additional_customer_segments)  
# pickle.dump(additional_customer_segments, open("./ref_result/additional_customer_segments.pkl", "wb")) 

